/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.quests.quest.area;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.common.quests.quest.area.IMobSpawnProcessor;
import dev.toma.gunsrpg.common.quests.quest.area.IMobSpawnProcessorSerializer;
import dev.toma.gunsrpg.common.quests.quest.area.RemoveSpecificTasksProcessor;
import dev.toma.gunsrpg.common.quests.quest.area.SetEffectProcessor;
import dev.toma.gunsrpg.common.quests.quest.area.SetEntityControllerProcessor;
import dev.toma.gunsrpg.common.quests.quest.area.SetEquipmentProcessor;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;

public final class MobSpawnProcessorType<P extends IMobSpawnProcessor> {
    private static final Map<ResourceLocation, MobSpawnProcessorType<?>> MAP = new HashMap();
    public static final MobSpawnProcessorType<SetEntityControllerProcessor> CONTROLLER = MobSpawnProcessorType.register(GunsRPG.makeResource("controller"), new SetEntityControllerProcessor.Serializer());
    public static final MobSpawnProcessorType<SetEquipmentProcessor> EQUIPMENT = MobSpawnProcessorType.register(GunsRPG.makeResource("set_equipment"), new SetEquipmentProcessor.Serializer());
    public static final MobSpawnProcessorType<SetEffectProcessor> EFFECT = MobSpawnProcessorType.register(GunsRPG.makeResource("set_effect"), new SetEffectProcessor.Serializer());
    public static final MobSpawnProcessorType<RemoveSpecificTasksProcessor> REMOVE_AI_GOALS = MobSpawnProcessorType.register(GunsRPG.makeResource("remove_ai_goals"), new RemoveSpecificTasksProcessor.Serializer());
    private final ResourceLocation id;
    private final IMobSpawnProcessorSerializer<P> serializer;

    public static <P extends IMobSpawnProcessor> MobSpawnProcessorType<P> register(ResourceLocation id, IMobSpawnProcessorSerializer<P> serializer) {
        MobSpawnProcessorType<P> type = new MobSpawnProcessorType<P>(id, serializer);
        MAP.put(id, type);
        return type;
    }

    public static <P extends IMobSpawnProcessor> MobSpawnProcessorType<P> findById(ResourceLocation location) {
        return MAP.get(location);
    }

    public MobSpawnProcessorType(ResourceLocation id, IMobSpawnProcessorSerializer<P> serializer) {
        this.id = id;
        this.serializer = serializer;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public IMobSpawnProcessorSerializer<P> getSerializer() {
        return this.serializer;
    }

    public CompoundNBT toNbt(P processor) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("type", this.id.toString());
        this.serializer.toNbt(processor, nbt);
        return nbt;
    }

    public static <P extends IMobSpawnProcessor> P fromNbt(CompoundNBT nbt) {
        ResourceLocation typeId = new ResourceLocation(nbt.func_74779_i("type"));
        MobSpawnProcessorType<P> type = MobSpawnProcessorType.findById(typeId);
        return type.serializer.fromNbt(type, nbt);
    }
}

